import "./App.css";
import Box from "./Box";
import { useEffect, useState } from "react";
import Confetti from "react-confetti";

function App() {
  const [boxes, setboxes] = useState(Array(9).fill(""));
  const [currentplayer, setcurrentplayer] = useState("X");

  const [winner, setwinner] = useState("");

  const [draw, setdraw] = useState(false);
  useEffect(() => {
    //checking for winner
    const winerPos = [
      [0, 1, 2],
      [3, 4, 5],
      [6, 7, 8],
      [0, 3, 6],
      [1, 4, 7],
      [2, 5, 8],
      [0, 4, 8],
      [2, 4, 6],
    ];

    for (let i = 0; i < winerPos.length; i++) {
      if (
        boxes[winerPos[i][0]] !== "" &&
        boxes[winerPos[i][0]] === boxes[winerPos[i][1]] &&
        boxes[winerPos[i][1]] === boxes[winerPos[i][2]]
      ) {
        // alert("The winner is :" + boxes[winerPos[i][0]]);
        setwinner(boxes[winerPos[i][0]]);
      }
    }
    //checking for draw
    const emptybox = boxes.filter((box) => box === "").length;
    if (emptybox === 0) {
      setdraw(true);
    }
    // console.log("inside use effect", boxes);
  }, [boxes]);

  const updatebox = (boxNum) => {
    if (boxes[boxNum] !== "") {
      return;
    }
    if (winner !== "") {
      return;
    }

    const newboxes = [...boxes];
    newboxes[boxNum] = currentplayer;
    setboxes(newboxes);

    //update player
    setcurrentplayer(currentplayer === "X" ? "O" : "X");
  };

  const restartGame = () => {
    setboxes(Array(9).fill(""));
    setwinner("");
    setdraw(false);
    setcurrentplayer("X");
  };

  return (
    <div className="container">
      {winner !== "" && <Confetti />}
      <h1>TIC-TOC-TOE</h1>
      {winner !== "" && <h1>Winner is:{winner}</h1>}
      {winner === "" && draw && <h1>Drow Here!!</h1>}

      <div className="boxes">
        {boxes.map((box, idx) => (
          <Box value={box} boxNum={idx} updatebox={updatebox} />
        ))}
      </div>
      {(winner !== "" || draw) && (
        <button onClick={restartGame}>Restart</button>
      )}
    </div>
  );
}
export default App;
